package gov.va.med.mhv.vitals.web.controller;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

import org.primefaces.component.datatable.DataTable;

/**
 * This Controller acts as a utility to lookup tables on the server via EL expression.  The last reference is cached
 * as an optimization.  If a new reference is requested, it clears the previous reference and replaces it.  For
 * requests that use just 1 table, this is much more performant.  Most importantly, this controller is RequestScoped.
 * This will eliminate the session-table binding that is triggering the defect in production where CPU spins out of
 * control.
 * 
 * @author DNS
 *
 */
@ManagedBean(name="tableController")
@RequestScoped
public class TableController {
	
	DataTable table = null;
	String reference = null;
	
	public DataTable table(String tableReference) {
		if (table == null || !tableReference.equals(reference)) {
			reference = tableReference;
			table = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent(tableReference);
		}
		return table;
	}
}
